/* chartjs plugin declaration */


/* Eventually events will be send 
 * to the LCS object so the user 
 * can handle it
 */
var afterRenderLCCallBackFunctionPlugin = {
  afterRender: function (chart, args, options) {
    liveCode.chartDrawFinished();
  },
};



/* Helper function for getting datasets internal properties */
function getDatasetProperties(obj, prop) {
  let result = "";
  for (let index = 0; index < obj.data.datasets.length; index++) {
    var Dataset = obj.data.datasets[index];
    if (typeof Dataset[prop] != "undefined") {
      result = result + Dataset[prop] + "\n";
    } else {
      result = result + "\n";
    }
  }
  return result;
}

/* Helper function for setting datasets internal properties */
function setDatasetProperties(obj, prop, values) {
  list = values.split(/\r\n|\r|\n/);
  var limit = Math.min(obj.data.datasets.length, list.length);
  for (let index = 0; index < limit; index++) {
    if (list[index] != "") {
      obj.data.datasets[index][prop] = list[index];
    }
  }
  obj.update();
}

/* Helper function for deleting specific property from datasets */
function clearDatasetProperties(obj, prop) {
  try {
    var limit = obj.data.datasets.length;
    for (let index = 0; index < limit; index++) {
      delete obj.data.datasets[index][prop];
    }
    obj.update();
  } catch (error) {}
}
